<?php ?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>CRUD Usuarios</title>

    <link href="../css/crud/color.css" rel="stylesheet" type="text/css" />
    <link href="../css/crud/easyui.css" rel="stylesheet" type="text/css" />
    <link href="../css/crud/general.css" rel="stylesheet" type="text/css" />
    <link href="../css/crud/icon.css" rel="stylesheet" type="text/css" />

    <script src="../js/jquery.min.js" type="text/javascript"></script>
    <script src="../js/jquery.easyui.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        function doSearch() {
            $('#dg').datagrid('load', {
                clave: $('#clave').val(),
                nomb: $('#nomb').val()
            });
            console.log($('#clave').val());
            console.log($('#nomb').val());
        }

    </script>
</head>

<body>
    <!--<script>
            $.messager.show({
            title:'My Title',
            msg:'Message will be closed after 5 seconds.',
            timeout:5000,
            showType:'slide'
            });
        </script>-->
    <p align="center"><img src="../css/crud/icons/users.png" width="20px" height="20px" /> </p>
    <h2 style="text-align:center">Usuarios</h2>

    <table id="dg" title="Usuarios" class="easyui-datagrid" style="width:100%;height:380px" url="get_users.php" toolbar="#toolbar" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true">
        <thead>
            <tr>
                <th field="oper" width="25">Oper</th>
                <th field="nombre" width="50">Usuario</th>
                <th field="clave" width="50">Contrasenia</th>
                <th field="nomb" width="50">Nombre</th>
                <th field="apa" width="50">apa</th>
                <th field="ama" width="50">ama</th>
                <th field="maestro" width="35">maestro</th>
                <th field="des_alm" width="35">des_alm</th>
                <th field="des_pun" width="35">des_pun</th>
                <th field="des_cos" width="35">des_cos</th>
                <th field="des_fro" width="35">des_fro</th>
            </tr>
        </thead>
    </table>

    <div id="toolbar">

        <span>Clave</span>
        <input id="clave" style="line-height:26px;border:1px solid #ccc">
        <span>Nombre:</span>
        <input id="nomb" style="line-height:26px;border:1px solid #ccc">
        <a href="#" class="easyui-linkbutton" iconCls="icon-search" plain="true" onclick="doSearch()">Search</a>

        <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="newUser()">Nuevo Usuario</a>
        <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editUser()">Editar Usuario</a>
        <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="destroyUser()">Eliminar Usuario</a>
    </div>

    <div id="dlg" class="easyui-dialog" style="width:400px;height:460px;padding:10px 20px" closed="true" buttons="#dlg-buttons">
        <div class="ftitle">Informacion Usuario</div>
        <form id="fm" method="post" novalidate>
            <div class="fitem">
                <label>Nombre:</label>
                <input name="nombre" class="easyui-textbox" required="true">
            </div>
            <div class="fitem">
                <label>Clave:</label>
                <input name="clave" class="easyui-textbox" required="true">
            </div>
            <div class="fitem">
                <label>Nomb:</label>
                <input name="nomb" class="easyui-textbox" required="true">
            </div>
            <div class="fitem">
                <label>APA:</label>
                <input name="apa" class="easyui-textbox" required="true">
            </div>
            <div class="fitem">
                <label>AMA:</label>
                <input name="ama" class="easyui-textbox" required="true">
            </div>
            <div class="fitem1">
                <label>Maestro:</label>
                <input name="maestro" class="checkbox" type="checkbox" value="1" checked>
            </div>
            <div class="fitem1">
                <label>Des_alm:</label>
                <input name="des_alm" class="checkbox" type="checkbox" value="1" checked>
            </div>
            <div class="fitem1">
                <label>Des_pun:</label>
                <input name="des_pun" class="checkbox" type="checkbox" value="1" checked>
            </div>
            <div class="fitem1">
                <label>Des_cos:</label>
                <input name="des_cos" class="checkbox" type="checkbox" value="1" checked>
            </div>
            <div class="fitem1">
                <label>Des_fro:</label>
                <input name="des_fro" class="checkbox" type="checkbox" value="1" checked>
            </div>
        </form>
    </div>
    <div id="dlg-buttons">
        <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-ok" onclick="saveUser()" style="width:90px">Guardar</a>
        <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlg').dialog('close')" style="width:90px">Cancelar</a>
    </div>
    <script type="text/javascript">
        var url;

        function newUser() {
            //window.location.assign("usuario.php");
            $('#dlg').dialog('open').dialog('setTitle', 'Nuevo Usuario');
            $('#fm').form('clear');
            url = 'save_user.php';
        }

        function editUser() {
            var row = $('#dg').datagrid('getSelected');
            if (row) {
                $('#dlg').dialog('open').dialog('setTitle', 'Editar Usuario');
                $('#fm').form('load', row);
                url = 'update_user.php?id=' + row.oper;
            }
        }

        function saveUser() {
            $('#fm').form('submit', {
                url: url,
                onSubmit: function() {
                    return $(this).form('validate');
                },
                success: function(result) {
                    var result = eval('(' + result + ')');
                    if (result.errorMsg) {
                        $.messager.show({
                            title: 'Error',
                            msg: result.errorMsg
                        });
                    } else {
                        $('#dlg').dialog('close'); // close the dialog
                        $('#dg').datagrid('reload'); // reload the user data
                    }
                }
            });
        }

        function destroyUser() {
            var row = $('#dg').datagrid('getSelected');
            if (row) {
                $.messager.confirm('Confirmar', 'Estas seguro que quieres eliminar este usuario?', function(r) {
                    if (r) {
                        $.post('destroy_user.php', {
                            id: row.oper
                        }, function(result) {
                            if (result.success) {
                                $('#dg').datagrid('reload'); // reload the user data
                            } else {
                                $.messager.show({ // show error message
                                    title: 'Error',
                                    msg: result.errorMsg
                                });
                            }
                        }, 'json');
                    }
                });
            }
        }

    </script>
    <style type="text/css">
        #fm {
            margin: 0;
            padding: 10px 30px;
        }

        .ftitle {
            font-size: 14px;
            font-weight: bold;
            padding: 5px 0;
            margin-bottom: 10px;
            border-bottom: 1px solid #ccc;
        }

        .fitem {
            margin-bottom: 5px;
        }

        .fitem label {
            display: inline-block;
            width: 80px;
        }

        .fitem input {
            width: 160px;
        }

        .fitem1 {
            margin-bottom: 5px;
            margin-top: 10px;
        }

        .fitem1 label {
            display: inline-block;
            width: 80px;
        }

        .fitem1 input {
            width: 30px;
            margin-left: 50px;
        }

    </style>
</body>

</html>
