<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" id="EL_3C">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="author" content="A. Sajjad Zaidi" />
<meta name="document-rights" content="Copyrighted Work" />
<meta name="copyright" content="Copyright 2009. A. Sajjad Zaidi. All Rights Reserved." />
<meta name="rating" content="General" />
<meta name="description" content="Collection of CSS buttons and tools to create your own simple buttons plus techniques to improve forms using css" />
<meta name="keywords" content="css button,css submit,css submit button,css forms,css buttons,button css,web design,web buttons,site buttons,cascading style sheets,ready-made buttons,text browsers,seo" />
<title>CSS input boxes and submit buttons | CSS button</title>

<!['endif']--><script type="text/javascript"> 
document.documentElement.className="JSon";
function switchTo(thisLayout,theAnchor){
	if (thisLayout=="FL_3C-minMax" || thisLayout=="FL_3C-100") {
		(thisLayout=="FL_3C-minMax") ? document.getElementsByTagName('body')[0].className="FL_3C-minMax" : document.getElementsByTagName('body')[0].className="FL_3C-100" ;
		document.documentElement.id="FL_3C";
	}else{
		document.getElementsByTagName('body')[0].className="";
		document.documentElement.id=thisLayout;
	}
	theAnchor.blur();
	return false;
}
function more(el,arg){
	document.getElementById(arg).style.display="block";
	el.nextSibling.style.display="block";
	el.style.display="none";
	return false;
}
function less(el,arg){
	document.getElementById(arg).style.display="none";
	el.previousSibling.style.display="block";
	el.style.display="none";
	return false;
}
</script>            
</head>
 
<body class="">
<ol id="wp">
	<li id="hd">
 
		<h1>CSS <a href="http://cssbutton.com/">button</a> <span>Using <abbr title="Cascading Styles Sheets">CSS</abbr> to style your web buttons and widgets</span></h1>
    </li>
	<li id="topmen">&nbsp;</li>
	<li id="bd"><i class="col4ie"></i><b class="col4ie"></b>
		<ol id="doc">
			<li id="s1">
           		<h3>buttons</h3>
				<ul id="btncat">
					<li><a href="/countries/">Countries</a></li>
					<li><a href="/fun/">Fun</a></li>
					<li><a href="/political/">Political</a></li>
					<li><a href="/web/">Web Design</a></li>
					<li><a href="/internet/">Internet</a></li>
					<li><a href="/linux/">Linux</a></li>
					<li><a href="/large/">Large</a></li>
					<li><a href="/others/">Others</a></li>
				</ul>
 
           		<h3>guides</h3>
				<ul id="btncat">
					<li><a href="/forms/">Forms</a></li>
					<li><a href="/maker/">Button Maker</a></li>
				</ul>
 
           		<h3>blogs</h3>
				<ul id="bloglist">
					<li><a href="http://www.xerxy.com">Xerxy</a></li>
					<li><a href="http://sajjadzaidi.com">SZ Blog</a></li>
				</ul>
 
				<h3>links</h3>
				<ul>
					<li><a href="/privacy/">Privacy Policy</a></li>
					<li><a href="http://whatismycountry.com">Whatismycountry</a></li>
					<li><a href="http://lang.sajjadzaidi.com">Languages</a></li>
					<li><a href="http://netutils.net">Network Utils</a></li>
					<li><a href="http://wimax.pk" title="WiMax portal for Pakistan">WiMax Pakistan</a></li>
					<li><a href="http://www.designdir.net">Web Design</a></li>
				</ul>
 
			</li>
			<li id="s2">
<h3>Input Boxes and Submit Buttons</h3>
<p>The days of bland web pages with ugly text and layout are long gone,
but the parts that make up a form have largely remained unchanged. Here,
I am attempting to describe various methods that may be used to enhance
the look of your input fields and form buttons.</p>
 
<!--<script type="text/javascript"><!--
google_ad_client = "pub-6831134257689102";
/* cssbutton, 468x60, top-banner, created 2/3/09 */
google_ad_slot = "5502410520";
google_ad_width = 468;
google_ad_height = 60;
//-->
</script>
<script type="text/javascript"
src="http://pagead2.googlesyndication.com/pagead/show_ads.js"> 
</script>
-->
 
<h3>Basic Form</h3>
<p>A very simple form might look like this:</p>
<p>
<form action="">
Name: <input type="text" /><br />
Password: <input type="password" /><br />
<input type="submit" value="Submit" />
</form>
</p>
<h5>Code</h5>
<p class="code">
&lt;form action=""&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;Name: &lt;input type="text" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;Password: &lt;input type="password" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;input type="submit" value="Submit" /&gt;<br />
&lt;/form&gt;
</p>
 
<h3>Enhanced Border</h3>
<p>We can improve on this by firstly changing the border of the form:</p>
<p>
<form action="">
Name: <input type="text" class="input" /><br />
Password: <input type="password" class="input" /><br />
<input type="submit" value="Submit" class="input" />
</form>
</p>
<h5>Code</h5>
<p class="code">
&lt;form action=""&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;Name: &lt;input type="text" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;Password: &lt;input type="password" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;input type="submit" value="Submit" class="input" /&gt;<br />
&lt;/form&gt;
</p>
<h5>CSS</h5>
<p class="code">
.input {
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #006;
}
</p>
 
 
<h3>Enhanced Background</h3>
<p>Now we work on the background:</p>
<p>
<form action="">
Name: <input type="text" class="input2" /><br />
Password: <input type="password" class="input2" /><br />
<input type="submit" value="Submit" class="button" />
</form>
</p>
<h5>Code</h5>
<p class="code">
&lt;form action=""&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;Name: &lt;input type="text" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;Password: &lt;input type="password" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;input type="submit" value="Submit" class="button" /&gt;<br />
&lt;/form&gt;
</p>
<h5>CSS</h5>
<p class="code">
.input {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #006;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #ffc;<br />
}<br />
.button {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #006;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #9cf;<br />
}<br />
</p>
 
<h3>Positioning</h3>
<p>Typically, a form and its labels are aligned with the help of tables.
Tables are generally frowned upon these days for anything other than
tabular data so it makes sense to use CSS for form layout.</p>
<p>Here, we'll wrap the labels in the &lt;label&gt; tag and add some CSS
for these to align them properly.</p>
<p>
<form action="">
<label>Name: </label> <input type="text" class="input2" /><br />
<label>Password: </label> <input type="password" class="input2" /><br />
<label>&nbsp; </label> <input type="submit" value="Submit" class="button" />
</form>
</p>
<h5>Code</h5>
<p class="code">
&lt;form action=""&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;Name: &lt;/label&gt; &lt;input type="text" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;Password: &lt;/label&gt; &lt;input type="password" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;&amp;nbsp; &lt;/label&gt; &lt;input type="submit" value="Submit" class="button" /&gt;<br />
&lt;/form&gt;
</p>
<h5>CSS</h5>
<p class="code">
.input {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #006;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #ffc;<br />
}<br />
.button {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #006;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #9cf;<br />
}<br />
label {<br />
&nbsp;&nbsp;&nbsp;&nbsp;display: block;<br />
&nbsp;&nbsp;&nbsp;&nbsp;width: 150px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;float: left;<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin: 2px 4px 6px 4px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;text-align: right;<br />
}<br />
br { clear: left; }<br />
</p>
 
<h3>Hover Effect</h3>
<p>We can build on the above to add a hover effect. Simply add another
element followed by ":hover":</p>
<p>
<form action="">
<label>Name: </label> <input type="text" class="input3" /><br />
<label>Password: </label> <input type="password" class="input3" /><br />
<label>&nbsp; </label> <input type="submit" value="Submit" class="button3" />
</form>
</p>
<h5>Code</h5>
<p class="code">
&lt;form action=""&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;Name: &lt;/label&gt; &lt;input type="text" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;Password: &lt;/label&gt; &lt;input type="password" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;&amp;nbsp; &lt;/label&gt; &lt;input type="submit" value="Submit" class="button" /&gt;<br />
&lt;/form&gt;
</p>
<h5>CSS</h5>
<p class="code">
.input {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #006;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #ffc;<br />
}<br />
.input:hover {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #f00;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #ff6;<br />
}<br />
.button {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #006;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #ccf;<br />
}<br />
.button:hover {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #f00;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #eef;<br />
}<br />
label {<br />
&nbsp;&nbsp;&nbsp;&nbsp;display: block;<br />
&nbsp;&nbsp;&nbsp;&nbsp;width: 150px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;float: left;<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin: 2px 4px 6px 4px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;text-align: right;<br />
}<br />
br { clear: left; }<br />
</p>
 
<h3>Using images for buttons</h3>
<p>Finally, here is an example of using CSS-enhanced images as the
background for your buttons. Separate images for the unpressed button,
hover effect and a pressed button may be used by simply setting the
border to "none" and specifying the URL in the background value:</p>
<p>
<form action="">
<label>Name: </label> <input type="text" class="input3" /><br />
<label>Password: </label> <input type="password" class="input3" /><br />
<label>&nbsp; </label> <input type="submit" value="Submit" class="button4" /> <input type="submit" value="Cancel " class="button4" />
</form>
</p>
 
<h5>Code</h5>
<p class="code">
&lt;form action=""&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;Name: &lt;/label&gt; &lt;input type="text" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;Password: &lt;/label&gt; &lt;input type="password" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;&amp;nbsp; &lt;/label&gt; &lt;input type="submit" value="Submit" class="button" /&gt; &lt;input type="submit" value="Cancel" class="button" /&gt;<br />
&lt;/form&gt;
</p>
<h5>CSS</h5>
<p class="code">
.input {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #006;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #ffc;<br />
}<br />
.input:hover {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #f00;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #ff6;<br />
}<br />
.button {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: none;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: url('/forms/up.png') no-repeat top left;<br />
&nbsp;&nbsp;&nbsp;&nbsp;padding: 2px 8px;<br />
}<br />
.button:hover {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: none;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: url('/forms/down.png') no-repeat top left;<br />
&nbsp;&nbsp;&nbsp;&nbsp;padding: 2px 8px;<br />
}<br />
label {<br />
&nbsp;&nbsp;&nbsp;&nbsp;display: block;<br />
&nbsp;&nbsp;&nbsp;&nbsp;width: 150px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;float: left;<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin: 2px 4px 6px 4px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;text-align: right;<br />
}<br />
br { clear: left; }<br />
</p>
 
<h3>Grouping things together</h3>
<p>We can also group the elements together and separate them from the
rest of the page by using the fieldset and legend elements.</p>
<p>
<form action="">
<fieldset>
<legend>My awesome form</legend>
<label>Name: </label> <input type="text" class="input3" /><br />
<label>Password: </label> <input type="password" class="input3" /><br />
<label>&nbsp; </label> <input type="submit" value="Submit" class="button4" /> <input type="submit" value="Cancel " class="button4" />
</fieldset>
</form>
</p>
 
<h5>Code</h5>
<p class="code">
&lt;form action=""&gt;<br />
&nbsp;&lt;fieldset&gt;<br />
&nbsp;&nbsp;&lt;legend&gt;My awesome form&lt;/legend&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;Name: &lt;/label&gt; &lt;input type="text" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;Password: &lt;/label&gt; &lt;input type="password" class="input" /&gt;<br />
&nbsp;&nbsp;&nbsp;&nbsp;&lt;label&gt;&amp;nbsp; &lt;/label&gt; &lt;input type="submit" value="Submit" class="button" /&gt; &lt;input type="submit" value="Cancel" class="button" /&gt;<br />
&nbsp;&lt;/fieldset&gt;<br />
&lt;/form&gt;
</p>
<h5>CSS</h5>
<p class="code">
.input {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #006;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #ffc;<br />
}<br />
.input:hover {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 1px solid #f00;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: #ff6;<br />
}<br />
.button {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: none;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: url('/forms/up.png') no-repeat top left;<br />
&nbsp;&nbsp;&nbsp;&nbsp;padding: 2px 8px;<br />
}<br />
.button:hover {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: none;<br />
&nbsp;&nbsp;&nbsp;&nbsp;background: url('/forms/down.png') no-repeat top left;<br />
&nbsp;&nbsp;&nbsp;&nbsp;padding: 2px 8px;<br />
}<br />
label {<br />
&nbsp;&nbsp;&nbsp;&nbsp;display: block;<br />
&nbsp;&nbsp;&nbsp;&nbsp;width: 150px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;float: left;<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin: 2px 4px 6px 4px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;text-align: right;<br />
}<br />
br { clear: left; }<br />
</p>
 
		    </li>
 
			<li id="s3">
<p>&nbsp;<br />
</p>
 
<!--<script type="text/javascript"><!--
google_ad_client = "pub-6831134257689102";
/* cssbutton, 250x250, main-sidebox, created 1/24/09 */
google_ad_slot = "8178432186";
google_ad_width = 250;
google_ad_height = 250;
//-->
</script>
<script type="text/javascript"
src="http://pagead2.googlesyndication.com/pagead/show_ads.js"> 
</script>-->
            </li>
		</ol>
	</li>
	<li id="ft">
		<h2>&nbsp;</h2>
		<p><a rel="license" href="http://creativecommons.org/licenses/by-sa/3.0/us/"><img alt="Creative Commons License" style="border-width:0" src="http://i.creativecommons.org/l/by-sa/3.0/us/88x31.png" /></a>
  Theme by <a href="http://www.tjkdesign.com/articles/css-layout/no_div_no_float_no_clear_no_hack_no_joke.asp">Thierry Koblentz :: TJK Design</a><br />
  Copyright &copy; 2009 - <a href="http://sajjadzaidi.com">A. Sajjad Zaidi</a></p>
    </li>
</ol>
</body>
</html>
