<?php ?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Grupos</title>
        
        <link href="../css/crud/easyui.css" rel="stylesheet" type="text/css"/>
        <link href="../css/crud/icon.css" rel="stylesheet" type="text/css"/>
        <link href="../css/crud//color.css" rel="stylesheet" type="text/css"/>
        <link href="../css/crud/general.css" rel="stylesheet" type="text/css"/>
        
        <script src="../js/jquery.min.js" type="text/javascript"></script>
        <script src="../js/jquery.easyui.min.js" type="text/javascript"></script>
         
    </head>
    <body>
        <p align="center"><img src="../css/crud/icons/users.png" width="20px" height="20px"/> </p>
        <h2 style="text-align:center">Grupos</h2>
                
        <table id="dg" title="Grupos" class="easyui-datagrid" style="width:100%;height:380px"
               url="get_grupo.php"
               toolbar="#toolbar" pagination="true"
               rownumbers="true" fitColumns="true" singleSelect="true">
            <thead>
                <tr>
<!--                    <th field="id" width="50">ID</th>-->
                    <th field="nombre" width="50">Nombre</th>
                    <th field="descripcion" width="50">Descripcion</th>
                </tr>
            </thead>
        </table>
        <div id="toolbar">
            <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="newGrupo()">Nuevo Grupo</a>
            <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editGrupo()">Editar Grupo</a>
            <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="destroyGrupo()">Eliminar Grupo</a>
        </div>

        <div id="dlg" class="easyui-dialog" style="width:400px;height:260px;padding:10px 20px"
             closed="true" buttons="#dlg-buttons">
            <div class="ftitle">Informacion de Grupo</div>
            <form id="fm" method="post" novalidate>
                <div class="fitem">
                    <label>Nombre:</label>
                    <input name="nombre" class="easyui-textbox" required="true">
                </div>
                <div class="fitem">
                    <label>Descripcion:</label>
                    <input name="descripcion" class="easyui-textbox" required="true">
                </div>
            </form>
        </div>
        <div id="dlg-buttons">
            <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-ok" onclick="saveGrupo()" style="width:90px">Guardar</a>
            <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlg').dialog('close')" style="width:90px">Cancelar</a>
        </div>
        <script type="text/javascript">
            var url;
            function newGrupo() {
                $('#dlg').dialog('open').dialog('setTitle', 'Nuevo Grupo');
                $('#fm').form('clear');
                url = 'save_grupo.php';
            }
            function editGrupo() {
                var row = $('#dg').datagrid('getSelected');
                if (row) {
                    $('#dlg').dialog('open').dialog('setTitle', 'Editar Grupo');
                    $('#fm').form('load', row);
                    url = 'update_grupo.php?ide=' + row.id;
                }
            }
            function saveGrupo() {
                $('#fm').form('submit', {
                    url: url,
                    onSubmit: function () {
                        return $(this).form('validate');
                    },
                    success: function (result) {
                        var result = eval('(' + result + ')');
                        if (result.errorMsg) {
                            $.messager.show({
                                title: 'Error',
                                msg: result.errorMsg
                            });
                        } else {
                            $('#dlg').dialog('close');		// close the dialog
                            $('#dg').datagrid('reload');	// reload the user data
                        }
                    }
                });
            }
            function destroyGrupo() {
                var row = $('#dg').datagrid('getSelected');
                if (row) {
                    $.messager.confirm('Confirmar', 'Estas seguro que quieres eliminar este grupo?', function (r) {
                        if (r) {
                            $.post('destroy_grupo.php', {id: row.id}, function (result) {
                                if (result.success) {
                                    $('#dg').datagrid('reload');	// reload the user data
                                } else {
                                    $.messager.show({// show error message
                                        title: 'Error',
                                        msg: result.errorMsg
                                    });
                                }
                            }, 'json');
                        }
                    });
                }
            }
        </script>
        <style type="text/css">
            #fm{
                margin:0;
                padding:10px 30px;
            }
            .ftitle{
                font-size:14px;
                font-weight:bold;
                padding:5px 0;
                margin-bottom:10px;
                border-bottom:1px solid #ccc;
            }
            .fitem{
                margin-bottom:20px;
            }
            .fitem label{
                display:inline-block;
                width:80px;
            }
            .fitem input{
                width:160px;
            }

            .fitem1{
                margin-bottom:5px;
                margin-top:10px;
            }
            .fitem1 label{
                display:inline-block;
                width:80px;
            }
            .fitem1 input{
                width:30px;
                margin-left: 50px;
            }

        </style>
        
        <div id="navegador">
            <a href="permiso_grupo/index.php"> <span class="icon"><img width="50" heigh="50" src="../css/crud/icons/permisos.png"></span> <span class="text">Permiso de grupo</span></a>
            <a href="../menuadmin.php" style="text-decoration:none"><img width="50" heigh="50" src="../css/crud/icons/back.png"></a>    
            <a href="usuario_grupo/index.php"> <img width="50" heigh="50" src="../css/crud/icons/grupo.png"> <span>Usuario por grupo</span></a>
        </div>
        <style>
            #navegador{
                text-align: center;
            }
            #navegador a:link{
                display: inline;
                text-decoration: none;
                margin: 50px;
                
            }
            #navegador a img{
                margin: auto;
                margin-top: 50px;
            }
        </style>
    </body>
</html>
